/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h14199.fulltext.FullText;
import org.h14199.fulltext.IndexInfo;
import org.h14199.util.SoftHashMap;

final class FullTextSettings {
    private static final Map<String, FullTextSettings> SETTINGS = new HashMap<String, FullTextSettings>();
    private boolean initialized;
    private final Set<String> ignoreList = new HashSet<String>();
    private final Map<String, Integer> words = new HashMap<String, Integer>();
    private final ConcurrentHashMap<Integer, IndexInfo> indexes = new ConcurrentHashMap();
    private final SoftHashMap<Connection, SoftHashMap<String, PreparedStatement>> cache = new SoftHashMap();
    private String whitespaceChars = " \t\n\r\f+\"*%&/()=?'!,.;:-_#@|^~`{}[]<>\\";

    private FullTextSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIgnored() {
        Set<String> set = this.ignoreList;
        synchronized (set) {
            this.ignoreList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnored(Iterable<String> iterable) {
        Set<String> set = this.ignoreList;
        synchronized (set) {
            for (String string : iterable) {
                string = FullTextSettings.normalizeWord(string);
                this.ignoreList.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWordList() {
        Map<String, Integer> map = this.words;
        synchronized (map) {
            this.words.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWordId(String string) {
        Map<String, Integer> map = this.words;
        synchronized (map) {
            return this.words.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWord(String string, Integer n) {
        Map<String, Integer> map = this.words;
        synchronized (map) {
            if (!this.words.containsKey(string)) {
                this.words.put(string, n);
            }
        }
    }

    protected IndexInfo getIndexInfo(int n) {
        return this.indexes.get(n);
    }

    protected void addIndexInfo(IndexInfo indexInfo) {
        this.indexes.put(indexInfo.id, indexInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertWord(String string) {
        string = FullTextSettings.normalizeWord(string);
        Set<String> set = this.ignoreList;
        synchronized (set) {
            if (this.ignoreList.contains(string)) {
                return null;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static FullTextSettings getInstance(Connection connection) throws SQLException {
        FullTextSettings fullTextSettings;
        String string = FullTextSettings.getIndexPath(connection);
        Map<String, FullTextSettings> map = SETTINGS;
        synchronized (map) {
            fullTextSettings = SETTINGS.get(string);
            if (fullTextSettings == null) {
                fullTextSettings = new FullTextSettings();
                SETTINGS.put(string, fullTextSettings);
            }
        }
        return fullTextSettings;
    }

    private static String getIndexPath(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL IFNULL(DATABASE_PATH(), 'MEM:' || DATABASE())");
        resultSet.next();
        String string = resultSet.getString(1);
        if ("MEM:UNNAMED".equals(string)) {
            throw FullText.throwException("Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        resultSet.close();
        return string;
    }

    protected synchronized PreparedStatement prepare(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement;
        SoftHashMap<String, PreparedStatement> softHashMap = this.cache.get(connection);
        if (softHashMap == null) {
            softHashMap = new SoftHashMap();
            this.cache.put(connection, softHashMap);
        }
        if ((preparedStatement = softHashMap.get(string)) != null && preparedStatement.getConnection().isClosed()) {
            preparedStatement = null;
        }
        if (preparedStatement == null) {
            preparedStatement = connection.prepareStatement(string);
            softHashMap.put(string, preparedStatement);
        }
        return preparedStatement;
    }

    protected void removeAllIndexes() {
        this.indexes.clear();
    }

    protected void removeIndexInfo(IndexInfo indexInfo) {
        this.indexes.remove(indexInfo.id);
    }

    protected void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeAll() {
        Map<String, FullTextSettings> map = SETTINGS;
        synchronized (map) {
            SETTINGS.clear();
        }
    }

    protected void setWhitespaceChars(String string) {
        this.whitespaceChars = string;
    }

    protected String getWhitespaceChars() {
        return this.whitespaceChars;
    }

    private static String normalizeWord(String string) {
        return string.toUpperCase();
    }
}

